//
//  MGRT.h
//  MySQL GRT
//
//  Created by Alfredo Kojima on 05/7/13.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#include <MySQLGRT/myx_grt_public_interface.h>


@class MShellTextView;
@class MGRTModuleLoader;

@interface MGRT : NSObject 
{
  MYX_GRT *_grt;
  
  MGRTModuleLoader *_objcLoader;
  
  NSMutableArray *_requestQueue;
  NSLock *_requestQueueLock;
  MPSemaphoreID _requestReady;

  MShellTextView *_console;

  id _outputHandler;
  SEL _outputSelector;
  
  id _messageHandler;
  SEL _messageSelector;
  
  MYX_GRT_ERROR _lastError;
  NSString *_lastErrorMessage;
  
  NSString *_appDictPath;
}

- (MYX_GRT*)grt;
- (void)initializeGRT:(NSString*)resourcePath;
- (void)setConsole:(MShellTextView*)textView;
- (void)outText:(NSString*)text;
- (void)outMessage:(NSString*)text type:(NSString*)type;
- (void)performShellCommand:(NSString*)command;
- (NSString*)shellPrompt;

- (MGRTModuleLoader*)objCLoader;

- (MYX_GRT_VALUE*)globalValue:(const char*)path;
- (MYX_GRT_VALUE*)globalRefValue:(const char*)path;
- (void)setGlobalValue:(MYX_GRT_VALUE*)value forPath:(const char*)path;

- (BOOL)saveAppDict;
- (BOOL)loadAppDictFromPath:(NSString*)path;
- (MYX_GRT_VALUE*)globalAppDict;

- (BOOL)scanStructsInPath:(NSString*)path;
- (BOOL)scanModulesInPath:(NSString*)path;
- (BOOL)resultIsError:(MYX_GRT_VALUE*)value;

- (BOOL)performModule:(NSString*)module
            procedure:(NSString*)procedure
            arguments:(NSArray*)args;

- (MYX_GRT_VALUE*)performModule:(NSString*)module
                       function:(NSString*)function
                      arguments:(NSArray*)args;

- (int)performModule:(NSString*)module
         intFunction:(NSString*)function
           arguments:(NSArray*)args;

- (NSString*)performModule:(NSString*)module
            stringFunction:(NSString*)function
                 arguments:(NSArray*)args;


- (void)setOutputHandler:(id)object
                selector:(SEL)selector;
- (void)resetOutputHandler;

- (void)setMessageHandler:(id)object
                 selector:(SEL)selector;
- (void)resetMessageHandler;

- (void)reportError:(MYX_GRT_ERROR)error;

- (MYX_GRT_ERROR)lastError;
- (NSString*)lastErrorDescription;

- (BOOL)resultIsError:(MYX_GRT_VALUE*)result;
- (void)reportErrorResult:(MYX_GRT_VALUE*)result;

+ (NSString*)errorText:(MYX_GRT_ERROR)error;

@end
